<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ app('locale.direction')->dir() }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Subscribe - {{ $form->title ?: $form->name }}</title>
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700" rel="stylesheet" />
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
@php
    $isEmbed = request()->boolean('embed');
@endphp

<body class="font-sans antialiased {{ $isEmbed ? 'bg-transparent' : 'bg-gray-50' }}">
    <div class="{{ $isEmbed ? 'flex items-start justify-center py-8 px-4 sm:px-6' : 'min-h-screen flex items-center justify-center py-12 px-4 sm:px-6 lg:px-8' }}">
        <div class="max-w-md w-full {{ $isEmbed ? 'space-y-6' : 'space-y-8' }}">
            @php
                $showTitle = data_get($form->settings, 'show_title', true);
                $showDescription = data_get($form->settings, 'show_description', true);
            @endphp

            @if($showTitle || ($showDescription && $form->description))
                <div>
                    @if($showTitle)
                        <h2 class="mt-6 text-center text-3xl font-extrabold text-gray-900">
                            {{ $form->title ?: $form->name }}
                        </h2>
                    @endif
                    @if($showDescription && $form->description)
                        <p class="mt-2 text-center text-sm text-gray-600">
                            {{ $form->description }}
                        </p>
                    @endif
                </div>
            @endif

            <form
                method="POST"
                action="{{ route('public.subscribe.store', $form->slug) }}"
                class="mt-8 space-y-6"
                x-data="subscribeForm('{{ route('public.subscribe.api', $form->slug) }}')"
                @submit.prevent="submit($event)"
            >
                @csrf

                @if(session('success'))
                    <div class="rounded-md bg-green-50 p-4">
                        <p class="text-sm text-green-800">{{ session('success') }}</p>
                    </div>
                @endif

                @if(session('error'))
                    <div class="rounded-md bg-red-50 p-4">
                        <p class="text-sm text-red-800">{{ session('error') }}</p>
                    </div>
                @endif

                @if($errors->any())
                    <div class="rounded-md bg-red-50 p-4">
                        <ul class="list-disc pl-5 text-sm text-red-800">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <div class="rounded-md shadow-sm -space-y-px">
                    @if(in_array('email', $form->fields ?? ['email']))
                        <div>
                            <label for="email" class="sr-only">Email address</label>
                            <input
                                id="email"
                                name="email"
                                type="email"
                                autocomplete="email"
                                required
                                class="appearance-none rounded-none relative block w-full px-3 py-2 border border-gray-300 placeholder-gray-500 text-gray-900 rounded-t-md focus:outline-none focus:ring-primary-500 focus:border-primary-500 focus:z-10 sm:text-sm"
                                placeholder="Email address"
                                value="{{ old('email') }}"
                            >
                        </div>
                    @endif

                    @if(in_array('first_name', $form->fields ?? []))
                        <div>
                            <label for="first_name" class="sr-only">First Name</label>
                            <input
                                id="first_name"
                                name="first_name"
                                type="text"
                                class="appearance-none rounded-none relative block w-full px-3 py-2 border border-gray-300 placeholder-gray-500 text-gray-900 focus:outline-none focus:ring-primary-500 focus:border-primary-500 focus:z-10 sm:text-sm"
                                placeholder="First Name"
                                value="{{ old('first_name') }}"
                            >
                        </div>
                    @endif

                    @if(in_array('last_name', $form->fields ?? []))
                        <div>
                            <label for="last_name" class="sr-only">Last Name</label>
                            <input
                                id="last_name"
                                name="last_name"
                                type="text"
                                class="appearance-none rounded-none relative block w-full px-3 py-2 border border-gray-300 placeholder-gray-500 text-gray-900 rounded-b-md focus:outline-none focus:ring-primary-500 focus:border-primary-500 focus:z-10 sm:text-sm"
                                placeholder="Last Name"
                                value="{{ old('last_name') }}"
                            >
                        </div>
                    @endif
                </div>

                @if($form->gdpr_checkbox)
                    <div class="flex items-center">
                        <input
                            id="gdpr_consent"
                            name="gdpr_consent"
                            type="checkbox"
                            required
                            class="h-4 w-4 text-primary-600 focus:ring-primary-500 border-gray-300 rounded"
                        >
                        <label for="gdpr_consent" class="ml-2 block text-sm text-gray-900">
                            {!! $form->gdpr_text ?? 'I agree to the processing of my personal data.' !!}
                        </label>
                    </div>
                @endif

                <div>
                    <button
                        type="submit"
                        :disabled="loading"
                        class="group relative w-full flex justify-center py-2 px-4 border border-transparent text-sm font-medium rounded-md text-white bg-primary-600 hover:bg-primary-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500"
                    >
                        <span x-show="!loading">Subscribe</span>
                        <span x-cloak x-show="loading">Submitting...</span>
                    </button>
                    <div
                        x-cloak
                        x-show="notice"
                        class="mt-3 rounded-md px-3 py-2 text-sm"
                        :class="noticeType === 'success'
                            ? 'bg-green-50 text-green-800'
                            : noticeType === 'exists'
                                ? 'bg-blue-50 text-blue-800'
                                : 'bg-red-50 text-red-800'"
                        x-text="notice"
                    ></div>
                </div>
            </form>
        </div>
    </div>

    <script>
        function subscribeForm(apiUrl) {
            return {
                loading: false,
                notice: '',
                noticeType: 'success',

                async submit(event) {
                    const formEl = event?.target;

                    // Fallback to normal form submission if axios isn't available
                    if (!formEl || !window.axios) {
                        formEl?.submit();
                        return;
                    }

                    this.loading = true;
                    this.notice = '';
                    this.noticeType = 'success';

                    try {
                        const fd = new FormData(formEl);
                        const payload = Object.fromEntries(fd.entries());

                        const res = await window.axios.post(apiUrl, payload, {
                            headers: {
                                'Accept': 'application/json',
                            },
                        });

                        this.notice = res?.data?.message || 'Successfully subscribed.';
                        this.noticeType = res?.data?.status || 'success';

                        // Optional: clear fields on success
                        if (this.noticeType === 'success') {
                            const emailEl = formEl.querySelector('input[name="email"]');
                            if (emailEl) {
                                emailEl.value = '';
                            }
                        }
                    } catch (e) {
                        const status = e?.response?.status;
                        const data = e?.response?.data;

                        this.noticeType = 'error';

                        if (status === 422 && data?.errors) {
                            const firstField = Object.keys(data.errors)[0];
                            const firstMsg = firstField ? data.errors[firstField]?.[0] : null;
                            this.notice = firstMsg || 'Validation failed.';
                        } else {
                            this.notice = data?.message || 'Failed to submit. Please try again.';
                        }
                    } finally {
                        this.loading = false;
                    }
                },
            };
        }
    </script>
</body>
</html>

