@extends('layouts.public')

@section('title', 'Self-Hosted Email Marketing Platform')
@section('pageId', 'home-5')

@php
    use App\Models\Setting;
    $navTheme = 'light';
    
    // Dynamic content from settings
    $heroTitle = Setting::get('hero_title', 'The Future of Email Marketing');
    $heroSubtitle = Setting::get('hero_subtitle', 'Launch powerful email campaigns with our self-hosted platform. Complete control, no limits, maximum deliverability.');
    $ctaText = Setting::get('cta_text', 'Start Free Trial');
    $ctaSecondaryText = Setting::get('cta_secondary_text', 'Watch Demo');
    
    // Stats
    $statEmails = Setting::get('stat_emails_sent', '50M+');
    $statUsers = Setting::get('stat_users', '10K+');
    $statUptime = Setting::get('stat_uptime', '99.9%');
    
    // Features
    $features = [
        [
            'icon' => 'mail',
            'title' => 'Advanced Campaigns',
            'description' => 'Create beautiful, responsive email campaigns with our drag-and-drop builder and smart templates.'
        ],
        [
            'icon' => 'users',
            'title' => 'Audience Segmentation',
            'description' => 'Target the right subscribers with powerful segmentation based on behavior and preferences.'
        ],
        [
            'icon' => 'bar-chart-2',
            'title' => 'Real-time Analytics',
            'description' => 'Track opens, clicks, and conversions with detailed analytics and visual reports.'
        ],
        [
            'icon' => 'zap',
            'title' => 'Marketing Automation',
            'description' => 'Set up automated workflows, drip campaigns, and trigger-based emails effortlessly.'
        ],
        [
            'icon' => 'shield',
            'title' => 'Data Privacy',
            'description' => 'Self-hosted solution means your data stays on your servers. Full GDPR compliance.'
        ],
        [
            'icon' => 'code',
            'title' => 'API & Integrations',
            'description' => 'Connect with your favorite tools through our REST API and native integrations.'
        ]
    ];
    
    // Integrations
    $integrations = [
        ['name' => 'Zapier', 'icon' => 'zap'],
        ['name' => 'Slack', 'icon' => 'message-square'],
        ['name' => 'WordPress', 'icon' => 'globe'],
        ['name' => 'Shopify', 'icon' => 'shopping-bag'],
        ['name' => 'Stripe', 'icon' => 'credit-card'],
        ['name' => 'HubSpot', 'icon' => 'target'],
    ];
    
    // Testimonials
    $testimonials = [
        [
            'quote' => 'This platform transformed our email marketing. We saw a 40% increase in open rates within the first month.',
            'author' => 'Sarah Johnson',
            'role' => 'Marketing Director',
            'company' => 'TechStart Inc.'
        ],
        [
            'quote' => 'Finally, a self-hosted solution that doesn\'t compromise on features. The automation capabilities are incredible.',
            'author' => 'Michael Chen',
            'role' => 'CEO',
            'company' => 'GrowthLabs'
        ],
        [
            'quote' => 'The best investment we made for our marketing stack. Full control, great deliverability, amazing support.',
            'author' => 'Emily Rodriguez',
            'role' => 'Head of Growth',
            'company' => 'ScaleUp Co.'
        ]
    ];
    
    // Pricing plans
    $plans = [
        [
            'name' => 'Starter',
            'price' => '29',
            'description' => 'Perfect for small businesses',
            'features' => ['Up to 5,000 subscribers', '10,000 emails/month', 'Basic templates', 'Email support'],
            'popular' => false
        ],
        [
            'name' => 'Professional',
            'price' => '79',
            'description' => 'For growing teams',
            'features' => ['Up to 25,000 subscribers', 'Unlimited emails', 'Advanced automation', 'Priority support', 'Custom branding'],
            'popular' => true
        ],
        [
            'name' => 'Enterprise',
            'price' => '199',
            'description' => 'For large organizations',
            'features' => ['Unlimited subscribers', 'Unlimited emails', 'Dedicated IP', 'SLA guarantee', 'Custom integrations', 'Account manager'],
            'popular' => false
        ]
    ];
    
    // FAQs
    $faqs = [
        [
            'question' => 'What makes this different from other email marketing platforms?',
            'answer' => 'Our platform is fully self-hosted, giving you complete control over your data and infrastructure. No per-email fees, no subscriber limits imposed by third parties, and maximum deliverability through your own servers.'
        ],
        [
            'question' => 'How difficult is the installation process?',
            'answer' => 'We provide one-click installers for popular hosting platforms, Docker containers, and detailed documentation. Most users are up and running within 15 minutes.'
        ],
        [
            'question' => 'Can I migrate from my current email service?',
            'answer' => 'Yes! We offer free migration assistance and support imports from all major email marketing platforms including Mailchimp, SendGrid, and ConvertKit.'
        ],
        [
            'question' => 'What kind of support do you offer?',
            'answer' => 'All plans include email support. Professional and Enterprise plans get priority support with faster response times, and Enterprise customers get a dedicated account manager.'
        ]
    ];
@endphp

@section('content')
<!-- Hero Section -->
<section class="relative min-h-screen flex items-center overflow-hidden bg-black">
    <!-- Background Gradient -->
    <div class="absolute inset-0 bg-gradient-to-br from-black via-gray-900 to-black"></div>
    
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 relative z-10 py-20">
        <div class="max-w-4xl mx-auto text-center mb-16">
            <!-- Heading with Gradient Text -->
            <h1 class="text-4xl sm:text-5xl lg:text-6xl xl:text-7xl font-bold mb-6 leading-tight">
                <span class="bg-gradient-to-r from-[#84cc16] via-[#84cc16] to-[#65a30d] bg-clip-text text-transparent">Elevate your email marketing</span>
            </h1>
            
            <!-- Subheading -->
            <p class="text-base sm:text-lg text-gray-400 mb-8 max-w-2xl mx-auto">
                Powerful email marketing platform for modern businesses
            </p>
            
            <!-- CTA Button -->
            <div class="mb-8">
                <a href="{{ route('register') }}" class="inline-flex items-center justify-center px-8 py-3.5 text-base font-semibold text-[#0d0d0d] bg-[#84cc16] rounded-lg hover:bg-[#73b512] transition-all duration-300 shadow-lg hover:shadow-xl">
                    Start your free trial
                </a>
            </div>
            
            <!-- Trust Badge -->
            <div class="flex items-center justify-center gap-2 text-sm text-gray-400">
                <span class="font-semibold text-white">Excellent</span>
                <div class="flex gap-0.5">
                    <svg class="w-5 h-5 fill-[#84cc16]" viewBox="0 0 24 24"><path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/></svg>
                    <svg class="w-5 h-5 fill-[#84cc16]" viewBox="0 0 24 24"><path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/></svg>
                    <svg class="w-5 h-5 fill-[#84cc16]" viewBox="0 0 24 24"><path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/></svg>
                    <svg class="w-5 h-5 fill-[#84cc16]" viewBox="0 0 24 24"><path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/></svg>
                    <svg class="w-5 h-5 fill-[#84cc16]" viewBox="0 0 24 24"><path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/></svg>
                </div>
                <span>4,000+ reviews on</span>
                <svg class="h-4" viewBox="0 0 126 24" fill="none"><path d="M30.4 9.4h-4.8v9.2h-2.4V9.4h-4.8V7.2h12v2.2zm7.6 2.8c0-.8-.2-1.4-.6-1.8-.4-.4-1-.6-1.8-.6s-1.4.2-1.8.6c-.4.4-.6 1-.6 1.8v6h-2.4v-11h2.4v.8c.6-.6 1.4-1 2.4-1 1 0 1.8.3 2.4.9.6.6.9 1.4.9 2.4v7.9H38v-6.1zm8.8-4.8v11h-2.4v-11h2.4zm0-3.2v2.4h-2.4V4.2h2.4zm7.6 14.4c-1 0-1.8-.3-2.4-.9-.6-.6-.9-1.4-.9-2.4v-4.5c0-1 .3-1.8.9-2.4.6-.6 1.4-.9 2.4-.9s1.8.3 2.4.9c.6.6.9 1.4.9 2.4v.8h-2.4v-.8c0-.4-.1-.7-.3-.9-.2-.2-.5-.3-.9-.3s-.7.1-.9.3c-.2.2-.3.5-.3.9v4.5c0 .4.1.7.3.9.2.2.5.3.9.3s.7-.1.9-.3c.2-.2.3-.5.3-.9v-1.2h2.4v1.2c0 1-.3 1.8-.9 2.4-.6.6-1.4.9-2.4.9zm11.2-11v2.2h-2.8v8.8h-2.4V9.8h-2.8V7.6h8zm7.2 0v11h-2.4v-.8c-.6.6-1.4 1-2.4 1-1 0-1.8-.3-2.4-.9-.6-.6-.9-1.4-.9-2.4v-7.9h2.4v7.9c0 .4.1.7.3.9.2.2.5.3.9.3s.7-.1.9-.3c.2-.2.3-.5.3-.9V7.6h2.4zm5.6 11.2c-1 0-1.8-.3-2.4-.9-.6-.6-.9-1.4-.9-2.4v-1.2h2.4v1.2c0 .4.1.7.3.9.2.2.5.3.9.3s.7-.1.9-.3c.2-.2.3-.5.3-.9 0-.4-.1-.7-.3-.9-.2-.2-.5-.4-.9-.6l-1.2-.6c-.6-.3-1.1-.6-1.4-1-.3-.4-.5-1-.5-1.6 0-1 .3-1.8.9-2.4.6-.6 1.4-.9 2.4-.9s1.8.3 2.4.9c.6.6.9 1.4.9 2.4v.8h-2.4v-.8c0-.4-.1-.7-.3-.9-.2-.2-.5-.3-.9-.3s-.7.1-.9.3c-.2.2-.3.5-.3.9 0 .4.1.7.3.9.2.2.5.4.9.6l1.2.6c.6.3 1.1.6 1.4 1 .3.4.5 1 .5 1.6 0 1-.3 1.8-.9 2.4-.6.6-1.4.9-2.4.9zm10.8-11v2.2h-2.8v8.8h-2.4V9.8h-2.8V7.6h8zm8 0v11h-2.4v-.8c-.6.6-1.4 1-2.4 1-1 0-1.8-.3-2.4-.9-.6-.6-.9-1.4-.9-2.4V7.6h2.4v7.9c0 .4.1.7.3.9.2.2.5.3.9.3s.7-.1.9-.3c.2-.2.3-.5.3-.9V7.6h2.4zm5.6 11.2c-1 0-1.8-.3-2.4-.9-.6-.6-.9-1.4-.9-2.4v-4.5c0-1 .3-1.8.9-2.4.6-.6 1.4-.9 2.4-.9s1.8.3 2.4.9c.6.6.9 1.4.9 2.4v.8h-2.4v-.8c0-.4-.1-.7-.3-.9-.2-.2-.5-.3-.9-.3s-.7.1-.9.3c-.2.2-.3.5-.3.9v4.5c0 .4.1.7.3.9.2.2.5.3.9.3s.7-.1.9-.3c.2-.2.3-.5.3-.9v-1.2h2.4v1.2c0 1-.3 1.8-.9 2.4-.6.6-1.4.9-2.4.9z" fill="#fff"/><path d="M8.8 9.2L12 2l3.2 7.2 7.8 1.1-5.6 5.5 1.3 7.8L12 19.8l-6.7 3.8 1.3-7.8L1 10.3l7.8-1.1z" fill="#84cc16"/></svg>
            </div>
        </div>
        
        <!-- Dashboard Preview -->
        <div class="max-w-6xl mx-auto">
            <div class="relative">
                <!-- Glow Effect -->
                <div class="absolute -inset-4 bg-[#84cc16]/10 rounded-3xl blur-3xl"></div>
                
                <!-- Browser Window -->
                <div class="relative bg-[#1a1a1a] rounded-2xl shadow-2xl overflow-hidden border border-gray-800">
                    <!-- Browser Chrome -->
                    <div class="flex items-center gap-2 px-4 py-3 bg-[#2a2a2a] border-b border-gray-700">
                        <div class="flex gap-1.5">
                            <div class="w-3 h-3 rounded-full bg-red-500"></div>
                            <div class="w-3 h-3 rounded-full bg-yellow-500"></div>
                            <div class="w-3 h-3 rounded-full bg-green-500"></div>
                        </div>
                        <div class="flex-1 flex items-center justify-center">
                            <div class="flex items-center gap-2 px-4 py-1.5 bg-[#1a1a1a] rounded-lg border border-gray-600 text-xs text-gray-400 max-w-md w-full">
                                <svg class="w-3 h-3" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/></svg>
                                <span>yourcompany.mailpurse.app</span>
                            </div>
                        </div>
                        <div class="flex items-center gap-2">
                            <svg class="w-4 h-4 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.684 13.342C8.886 12.938 9 12.482 9 12c0-.482-.114-.938-.316-1.342m0 2.684a3 3 0 110-2.684m0 2.684l6.632 3.316m-6.632-6l6.632-3.316m0 0a3 3 0 105.367-2.684 3 3 0 00-5.367 2.684zm0 9.316a3 3 0 105.368 2.684 3 3 0 00-5.368-2.684z"/></svg>
                            <svg class="w-4 h-4 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 5v.01M12 12v.01M12 19v.01M12 6a1 1 0 110-2 1 1 0 010 2zm0 7a1 1 0 110-2 1 1 0 010 2zm0 7a1 1 0 110-2 1 1 0 010 2z"/></svg>
                        </div>
                    </div>
                    
                    <!-- Dashboard Content -->
                    <div class="bg-[#0d0d0d] p-6">
                        <!-- Top Navigation -->
                        <div class="flex items-center justify-between mb-6 pb-4 border-b border-gray-800">
                            <div class="flex items-center gap-6">
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 bg-gradient-to-br from-[#84cc16] to-[#65a30d] rounded-lg flex items-center justify-center">
                                        <svg class="w-5 h-5 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
                                    </div>
                                    <span class="text-white font-semibold">MailPurse</span>
                                </div>
                                <nav class="flex items-center gap-6">
                                    <a href="#" class="text-[#84cc16] font-medium">Analytics</a>
                                    <a href="#" class="text-gray-400 hover:text-white transition-colors">Campaigns</a>
                                    <a href="#" class="text-gray-400 hover:text-white transition-colors">Lists</a>
                                    <a href="#" class="text-gray-400 hover:text-white transition-colors">Reports</a>
                                </nav>
                            </div>
                            <div class="flex items-center gap-3">
                                <button class="p-2 text-gray-400 hover:text-white transition-colors">
                                    <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"/></svg>
                                </button>
                                <div class="w-8 h-8 bg-gradient-to-br from-purple-500 to-pink-500 rounded-full"></div>
                            </div>
                        </div>
                        
                        <!-- Analytics Dashboard -->
                        <div class="grid grid-cols-12 gap-6">
                            <!-- Left Column - Stats -->
                            <div class="col-span-3 space-y-4">
                                <div class="bg-[#1a1a1a] rounded-lg p-4 border border-gray-800">
                                    <div class="text-gray-400 text-xs uppercase tracking-wider mb-2">Total Revenue</div>
                                    <div class="text-2xl font-bold text-white">$84,254</div>
                                    <div class="flex items-center gap-1 mt-2">
                                        <svg class="w-4 h-4 text-green-500" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"/></svg>
                                        <span class="text-green-500 text-sm">+12.5%</span>
                                    </div>
                                </div>
                                
                                <div class="bg-[#1a1a1a] rounded-lg p-4 border border-gray-800">
                                    <div class="text-gray-400 text-xs uppercase tracking-wider mb-2">Active Users</div>
                                    <div class="text-2xl font-bold text-white">2,845</div>
                                    <div class="flex items-center gap-1 mt-2">
                                        <svg class="w-4 h-4 text-green-500" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"/></svg>
                                        <span class="text-green-500 text-sm">+8.2%</span>
                                    </div>
                                </div>
                                
                                <div class="bg-[#1a1a1a] rounded-lg p-4 border border-gray-800">
                                    <div class="text-gray-400 text-xs uppercase tracking-wider mb-2">Conversion</div>
                                    <div class="text-2xl font-bold text-white">3.24%</div>
                                    <div class="flex items-center gap-1 mt-2">
                                        <svg class="w-4 h-4 text-red-500" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 17h8m0 0V9m0 8l-8-8-4 4-6-6"/></svg>
                                        <span class="text-red-500 text-sm">-2.1%</span>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Center Column - Line Chart -->
                            <div class="col-span-6">
                                <div class="bg-[#1a1a1a] rounded-lg p-6 border border-gray-800">
                                    <div class="flex items-center justify-between mb-4">
                                        <h3 class="text-white font-semibold">Revenue Overview</h3>
                                        <select class="bg-[#2a2a2a] text-gray-300 text-sm px-3 py-1 rounded border border-gray-700">
                                            <option>Last 7 days</option>
                                            <option>Last 30 days</option>
                                            <option>Last 90 days</option>
                                        </select>
                                    </div>
                                    <!-- Line Chart Area -->
                                    <div class="h-64 relative">
                                        <!-- Grid Lines -->
                                        <div class="absolute inset-0 flex flex-col justify-between">
                                            <div class="border-t border-gray-800"></div>
                                            <div class="border-t border-gray-800"></div>
                                            <div class="border-t border-gray-800"></div>
                                            <div class="border-t border-gray-800"></div>
                                            <div class="border-t border-gray-800"></div>
                                        </div>
                                        <!-- Line Chart -->
                                        <svg class="w-full h-full" viewBox="0 0 600 256">
                                            <!-- Line -->
                                            <path d="M 50 200 Q 100 180, 150 160 T 250 140 Q 300 130, 350 100 T 450 80 Q 500 70, 550 60" 
                                                  stroke="#84cc16" stroke-width="3" fill="none"/>
                                            <!-- Area under line -->
                                            <path d="M 50 200 Q 100 180, 150 160 T 250 140 Q 300 130, 350 100 T 450 80 Q 500 70, 550 60 L 550 256 L 50 256 Z" 
                                                  fill="url(#gradient)" opacity="0.1"/>
                                            <!-- Gradient Definition -->
                                            <defs>
                                                <linearGradient id="gradient" x1="0%" y1="0%" x2="0%" y2="100%">
                                                    <stop offset="0%" style="stop-color:#84cc16;stop-opacity:0.5" />
                                                    <stop offset="100%" style="stop-color:#84cc16;stop-opacity:0" />
                                                </linearGradient>
                                            </defs>
                                            <!-- Data Points -->
                                            <circle cx="50" cy="200" r="4" fill="#84cc16"/>
                                            <circle cx="150" cy="160" r="4" fill="#84cc16"/>
                                            <circle cx="250" cy="140" r="4" fill="#84cc16"/>
                                            <circle cx="350" cy="100" r="4" fill="#84cc16"/>
                                            <circle cx="450" cy="80" r="4" fill="#84cc16"/>
                                            <circle cx="550" cy="60" r="4" fill="#84cc16"/>
                                        </svg>
                                    </div>
                                    <div class="flex justify-between mt-2 text-xs text-gray-500">
                                        <span>Mon</span>
                                        <span>Tue</span>
                                        <span>Wed</span>
                                        <span>Thu</span>
                                        <span>Fri</span>
                                        <span>Sat</span>
                                        <span>Sun</span>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Right Column - Campaign Stats -->
                            <div class="col-span-3 space-y-4">
                                <div class="bg-[#1a1a1a] rounded-lg p-4 border border-gray-800">
                                    <h3 class="text-white font-semibold mb-4">Campaign Stats</h3>
                                    <div class="space-y-3">
                                        <div class="flex items-center justify-between">
                                            <span class="text-gray-400 text-sm">Sent</span>
                                            <span class="text-white font-medium">12,453</span>
                                        </div>
                                        <div class="flex items-center justify-between">
                                            <span class="text-gray-400 text-sm">Delivered</span>
                                            <span class="text-white font-medium">11,892</span>
                                        </div>
                                        <div class="flex items-center justify-between">
                                            <span class="text-gray-400 text-sm">Opened</span>
                                            <span class="text-white font-medium">8,234</span>
                                        </div>
                                        <div class="flex items-center justify-between">
                                            <span class="text-gray-400 text-sm">Clicked</span>
                                            <span class="text-white font-medium">1,245</span>
                                        </div>
                                        <div class="h-px bg-gray-800 my-3"></div>
                                        <div class="flex items-center justify-between">
                                            <span class="text-gray-400 text-sm">Open Rate</span>
                                            <span class="text-green-400 font-medium">69.2%</span>
                                        </div>
                                        <div class="flex items-center justify-between">
                                            <span class="text-gray-400 text-sm">Click Rate</span>
                                            <span class="text-green-400 font-medium">10.5%</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Logos/Trusted By Section -->
<section class="py-16 bg-white border-b border-gray-100">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <p class="text-center text-sm font-medium text-gray-500 uppercase tracking-wider mb-8">Trusted by innovative companies worldwide</p>
        <div class="flex flex-wrap items-center justify-center gap-8 md:gap-16 opacity-60">
            @for($i = 1; $i <= 6; $i++)
            <div class="flex items-center justify-center h-8 grayscale hover:grayscale-0 transition-all duration-300">
                <img src="https://placehold.co/120x40/e2e8f0/64748b?text=Logo+{{ $i }}" alt="Company Logo" class="h-full w-auto object-contain">
            </div>
            @endfor
        </div>
    </div>
</section>

<!-- Features Section -->
<section id="features" class="py-24 bg-white">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Section Header -->
        <div class="max-w-3xl mx-auto text-center mb-16">
            <h2 class="text-3xl sm:text-4xl lg:text-5xl font-bold text-gray-900 mb-4">Everything you need to succeed</h2>
            <p class="text-lg text-gray-600">everything in between from within Lexend.</p>
        </div>
        
        <!-- Features Grid -->
        <div class="grid md:grid-cols-3 gap-8 max-w-7xl mx-auto">
            <!-- Feature 1: Integrations -->
            <div class="group relative bg-gradient-to-br from-gray-50 to-white rounded-3xl p-8 border border-gray-200 hover:shadow-xl transition-all duration-300">
                <!-- Browser Window Mockup -->
                <div class="mb-6">
                    <div class="bg-[#0a3d3d] rounded-xl overflow-hidden shadow-lg">
                        <!-- Browser Chrome -->
                        <div class="flex items-center gap-1.5 px-3 py-2 border-b border-white/10">
                            <div class="w-2 h-2 rounded-full bg-red-400"></div>
                            <div class="w-2 h-2 rounded-full bg-yellow-400"></div>
                            <div class="w-2 h-2 rounded-full bg-green-400"></div>
                        </div>
                        
                        <!-- Content -->
                        <div class="p-6 bg-white">
                            <div class="text-xs text-gray-500 mb-3">1000+ Apps & Integrations</div>
                            <div class="text-lg font-bold text-gray-900 mb-4">My apps</div>
                            
                            <!-- App List -->
                            <div class="space-y-3">
                                <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                                    <div class="flex items-center gap-3">
                                        <div class="w-8 h-8 rounded-lg bg-red-100 flex items-center justify-center">
                                            <div class="w-4 h-4 bg-red-500 rounded"></div>
                                        </div>
                                        <span class="font-medium text-sm">Asana</span>
                                    </div>
                                    <div class="w-6 h-6 rounded-full border-2 border-[#84cc16] flex items-center justify-center">
                                        <div class="w-2 h-2 bg-[#84cc16] rounded-full"></div>
                                    </div>
                                </div>
                                
                                <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                                    <div class="flex items-center gap-3">
                                        <div class="w-8 h-8 rounded-lg bg-yellow-100 flex items-center justify-center">
                                            <div class="w-4 h-4 bg-yellow-500 rounded"></div>
                                        </div>
                                        <span class="font-medium text-sm">Mailchimp</span>
                                    </div>
                                    <div class="w-6 h-6 rounded-full border-2 border-[#84cc16] flex items-center justify-center">
                                        <div class="w-2 h-2 bg-[#84cc16] rounded-full"></div>
                                    </div>
                                </div>
                                
                                <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                                    <div class="flex items-center gap-3">
                                        <div class="w-8 h-8 rounded-lg bg-orange-100 flex items-center justify-center">
                                            <div class="w-4 h-4 bg-orange-500 rounded"></div>
                                        </div>
                                        <span class="font-medium text-sm">Zapier</span>
                                    </div>
                                    <div class="w-6 h-6 rounded-full border-2 border-[#84cc16] flex items-center justify-center">
                                        <div class="w-2 h-2 bg-[#84cc16] rounded-full"></div>
                                    </div>
                                </div>
                                
                                <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                                    <div class="flex items-center gap-3">
                                        <div class="w-8 h-8 rounded-lg bg-blue-100 flex items-center justify-center">
                                            <div class="w-4 h-4 bg-blue-500 rounded"></div>
                                        </div>
                                        <span class="font-medium text-sm">Drive</span>
                                    </div>
                                    <div class="w-6 h-6 rounded-full border-2 border-[#84cc16] flex items-center justify-center">
                                        <div class="w-2 h-2 bg-[#84cc16] rounded-full"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <h3 class="text-xl font-bold text-gray-900 mb-3">Seamless integrations with your existing tools</h3>
                
                <a href="#" class="inline-flex items-center gap-2 px-6 py-2.5 bg-[#84cc16] text-[#0a3d3d] font-semibold rounded-lg hover:bg-[#73b512] transition-colors">
                    Try it now
                    <svg class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/></svg>
                </a>
            </div>
            
            <!-- Feature 2: Dashboard -->
            <div class="group relative bg-gradient-to-br from-gray-50 to-white rounded-3xl p-8 border border-gray-200 hover:shadow-xl transition-all duration-300">
                <!-- Browser Window Mockup -->
                <div class="mb-6">
                    <div class="bg-[#0a3d3d] rounded-xl overflow-hidden shadow-lg">
                        <!-- Browser Chrome -->
                        <div class="flex items-center gap-1.5 px-3 py-2 border-b border-white/10">
                            <div class="w-2 h-2 rounded-full bg-red-400"></div>
                            <div class="w-2 h-2 rounded-full bg-yellow-400"></div>
                            <div class="w-2 h-2 rounded-full bg-green-400"></div>
                        </div>
                        
                        <!-- Content -->
                        <div class="p-6 bg-white">
                            <div class="text-xs text-gray-500 mb-3">Most Growing Businesses</div>
                            <div class="text-lg font-bold text-gray-900 mb-4">Scalable plans</div>
                            
                            <!-- Donut Chart -->
                            <div class="relative w-full aspect-square max-w-[200px] mx-auto">
                                <svg viewBox="0 0 100 100" class="transform -rotate-90">
                                    <!-- Background circle -->
                                    <circle cx="50" cy="50" r="35" fill="none" stroke="#f3f4f6" stroke-width="15"/>
                                    <!-- Green segment (50%) -->
                                    <circle cx="50" cy="50" r="35" fill="none" stroke="#84cc16" stroke-width="15" stroke-dasharray="110 220" stroke-dashoffset="0"/>
                                    <!-- Teal segment (30%) -->
                                    <circle cx="50" cy="50" r="35" fill="none" stroke="#0a3d3d" stroke-width="15" stroke-dasharray="66 220" stroke-dashoffset="-110"/>
                                    <!-- Pink segment (20%) -->
                                    <circle cx="50" cy="50" r="35" fill="none" stroke="#fecaca" stroke-width="15" stroke-dasharray="44 220" stroke-dashoffset="-176"/>
                                </svg>
                                <div class="absolute inset-0 flex items-center justify-center">
                                    <div class="text-center">
                                        <div class="text-xs text-gray-500">Total</div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Legend -->
                            <div class="flex justify-center gap-4 mt-4 text-xs">
                                <div class="flex items-center gap-1">
                                    <div class="w-2 h-2 rounded-full bg-[#84cc16]"></div>
                                    <span class="text-gray-600">Value 1</span>
                                </div>
                                <div class="flex items-center gap-1">
                                    <div class="w-2 h-2 rounded-full bg-[#0a3d3d]"></div>
                                    <span class="text-gray-600">Value 2</span>
                                </div>
                                <div class="flex items-center gap-1">
                                    <div class="w-2 h-2 rounded-full bg-[#fecaca]"></div>
                                    <span class="text-gray-600">Value 3</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <h3 class="text-xl font-bold text-gray-900 mb-3">Intuitive dashboard for at-a-glance insights</h3>
                
                <a href="#" class="inline-flex items-center gap-2 px-6 py-2.5 bg-[#84cc16] text-[#0a3d3d] font-semibold rounded-lg hover:bg-[#73b512] transition-colors">
                    Try it now
                    <svg class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/></svg>
                </a>
            </div>
            
            <!-- Feature 3: Reports -->
            <div class="group relative bg-gradient-to-br from-gray-50 to-white rounded-3xl p-8 border border-gray-200 hover:shadow-xl transition-all duration-300">
                <!-- Browser Window Mockup -->
                <div class="mb-6">
                    <div class="bg-[#0a3d3d] rounded-xl overflow-hidden shadow-lg">
                        <!-- Browser Chrome -->
                        <div class="flex items-center gap-1.5 px-3 py-2 border-b border-white/10">
                            <div class="w-2 h-2 rounded-full bg-red-400"></div>
                            <div class="w-2 h-2 rounded-full bg-yellow-400"></div>
                            <div class="w-2 h-2 rounded-full bg-green-400"></div>
                        </div>
                        
                        <!-- Content -->
                        <div class="p-6 bg-white">
                            <div class="text-xs text-gray-500 mb-3">Project Reports</div>
                            <div class="text-lg font-bold text-gray-900 mb-4">Today's reports</div>
                            
                            <!-- Bar Chart -->
                            <div class="flex items-end justify-between h-32 gap-1">
                                @for($i = 0; $i < 12; $i++)
                                <div class="flex-1 flex flex-col justify-end gap-0.5">
                                    <div class="w-full bg-[#84cc16] rounded-t" style="height: {{ rand(40, 90) }}%"></div>
                                    <div class="w-full bg-[#0a3d3d] rounded-b" style="height: {{ rand(30, 60) }}%"></div>
                                </div>
                                @endfor
                            </div>
                            
                            <!-- Legend -->
                            <div class="flex justify-center gap-4 mt-4 text-xs">
                                <div class="flex items-center gap-1">
                                    <div class="w-2 h-2 rounded-full bg-[#84cc16]"></div>
                                    <span class="text-gray-600">Series 1</span>
                                </div>
                                <div class="flex items-center gap-1">
                                    <div class="w-2 h-2 rounded-full bg-[#0a3d3d]"></div>
                                    <span class="text-gray-600">Series 2</span>
                                </div>
                                <div class="flex items-center gap-1">
                                    <div class="w-2 h-2 rounded-full bg-gray-200"></div>
                                    <span class="text-gray-600">Series 3</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <h3 class="text-xl font-bold text-gray-900 mb-3">Automated data analysis and reporting</h3>
                
                <a href="#" class="inline-flex items-center gap-2 px-6 py-2.5 bg-[#84cc16] text-[#0a3d3d] font-semibold rounded-lg hover:bg-[#73b512] transition-colors">
                    Try it now
                    <svg class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/></svg>
                </a>
            </div>
        </div>
    </div>
</section>

<!-- How It Works Section -->
<section class="py-24 bg-slate-900 text-white">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="max-w-3xl mx-auto text-center mb-16">
            <span class="inline-block px-4 py-1.5 text-sm font-semibold text-purple-300 bg-purple-500/20 rounded-full mb-4">How It Works</span>
            <h2 class="text-3xl sm:text-4xl lg:text-5xl font-bold mb-6">Get started in minutes</h2>
            <p class="text-lg text-gray-400">Three simple steps to transform your email marketing strategy.</p>
        </div>
        
        <div class="grid md:grid-cols-3 gap-8 lg:gap-12">
            @php
            $steps = [
                ['number' => '01', 'title' => 'Install & Configure', 'description' => 'Deploy on your server with our one-click installer or Docker container. Configure your SMTP settings.'],
                ['number' => '02', 'title' => 'Import & Segment', 'description' => 'Import your subscriber lists, create segments, and set up your audience targeting criteria.'],
                ['number' => '03', 'title' => 'Create & Launch', 'description' => 'Design beautiful emails, set up automation workflows, and launch your campaigns.']
            ];
            @endphp
            
            @foreach($steps as $step)
            <div class="relative group">
                <div class="text-7xl font-bold text-purple-500/20 mb-4">{{ $step['number'] }}</div>
                <h3 class="text-2xl font-bold mb-4">{{ $step['title'] }}</h3>
                <p class="text-gray-400 leading-relaxed">{{ $step['description'] }}</p>
            </div>
            @endforeach
        </div>
    </div>
</section>

<!-- Integrations Section -->
<section class="py-24 bg-gray-50">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid lg:grid-cols-2 gap-16 items-center">
            <div>
                <span class="inline-block px-4 py-1.5 text-sm font-semibold text-purple-700 bg-purple-100 rounded-full mb-4">Integrations</span>
                <h2 class="text-3xl sm:text-4xl font-bold text-gray-900 mb-6">Connect with your favorite tools</h2>
                <p class="text-lg text-gray-600 mb-8">Seamlessly integrate with the tools you already use. Our platform works with 100+ popular services out of the box.</p>
                
                <div class="grid grid-cols-3 gap-4 mb-8">
                    @foreach($integrations as $integration)
                    <div class="flex items-center gap-3 p-4 bg-white rounded-xl border border-gray-200 hover:border-purple-300 hover:shadow-md transition-all duration-300">
                        <div class="w-10 h-10 rounded-lg bg-purple-100 flex items-center justify-center text-purple-600">
                            <i data-lucide="{{ $integration['icon'] }}" class="w-5 h-5"></i>
                        </div>
                        <span class="font-medium text-gray-900">{{ $integration['name'] }}</span>
                    </div>
                    @endforeach
                </div>
                
                <a href="#" class="inline-flex items-center text-purple-600 font-semibold hover:text-purple-700 group">
                    View all integrations
                    <i data-lucide="arrow-right" class="w-4 h-4 ml-2 group-hover:translate-x-1 transition-transform"></i>
                </a>
            </div>
            
            <div class="relative">
                <div class="absolute -inset-4 bg-gradient-to-r from-purple-400 to-indigo-400 rounded-2xl blur-2xl opacity-20"></div>
                <img src="https://placehold.co/600x500/ffffff/84cc16?text=1000%2B+Integrations" alt="Integrations" class="relative rounded-2xl shadow-xl w-full">
            </div>
        </div>
    </div>
</section>

<!-- Testimonials Section -->
<section class="py-24 bg-white overflow-hidden">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="max-w-3xl mx-auto text-center mb-16">
            <span class="inline-block px-4 py-1.5 text-sm font-semibold text-purple-700 bg-purple-100 rounded-full mb-4">Testimonials</span>
            <h2 class="text-3xl sm:text-4xl lg:text-5xl font-bold text-gray-900 mb-6">Loved by marketers worldwide</h2>
            <p class="text-lg text-gray-600">See what our customers have to say about their experience.</p>
        </div>
        
        <!-- Sliding Testimonials -->
        <div class="relative">
            <!-- Gradient Overlays -->
            <div class="absolute left-0 top-0 bottom-0 w-32 bg-gradient-to-r from-white via-white/90 to-transparent z-10 pointer-events-none"></div>
            <div class="absolute right-0 top-0 bottom-0 w-32 bg-gradient-to-l from-white via-white/90 to-transparent z-10 pointer-events-none"></div>
            
            <!-- Track -->
            <div class="flex gap-8 animate-scroll" style="animation: scroll 30s linear infinite;">
                <!-- First Set -->
                @foreach($testimonials as $testimonial)
                <div class="flex-none w-80 group relative bg-white rounded-2xl p-8 border border-gray-200 hover:border-purple-300 hover:shadow-xl transition-all duration-300">
                    <!-- Quote Icon -->
                    <div class="absolute top-6 right-6 text-purple-200">
                        <i data-lucide="quote" class="w-10 h-10"></i>
                    </div>
                    
                    <!-- Stars -->
                    <div class="flex gap-1 mb-6">
                        @for($i = 0; $i < 5; $i++)
                        <i data-lucide="star" class="w-5 h-5 fill-yellow-400 text-yellow-400"></i>
                        @endfor
                    </div>
                    
                    <!-- Quote -->
                    <p class="text-gray-700 leading-relaxed mb-8">"{{ $testimonial['quote'] }}"</p>
                    
                    <!-- Author -->
                    <div class="flex items-center gap-4">
                        <div class="w-12 h-12 rounded-full bg-gradient-to-br from-purple-500 to-indigo-600 flex items-center justify-center text-white font-bold">
                            {{ substr($testimonial['author'], 0, 1) }}
                        </div>
                        <div>
                            <div class="font-semibold text-gray-900">{{ $testimonial['author'] }}</div>
                            <div class="text-sm text-gray-500">{{ $testimonial['role'] }}, {{ $testimonial['company'] }}</div>
                        </div>
                    </div>
                </div>
                @endforeach
                
                <!-- Duplicate Set for Seamless Loop -->
                @foreach($testimonials as $testimonial)
                <div class="flex-none w-80 group relative bg-white rounded-2xl p-8 border border-gray-200 hover:border-purple-300 hover:shadow-xl transition-all duration-300">
                    <!-- Quote Icon -->
                    <div class="absolute top-6 right-6 text-purple-200">
                        <i data-lucide="quote" class="w-10 h-10"></i>
                    </div>
                    
                    <!-- Stars -->
                    <div class="flex gap-1 mb-6">
                        @for($i = 0; $i < 5; $i++)
                        <i data-lucide="star" class="w-5 h-5 fill-yellow-400 text-yellow-400"></i>
                        @endfor
                    </div>
                    
                    <!-- Quote -->
                    <p class="text-gray-700 leading-relaxed mb-8">"{{ $testimonial['quote'] }}"</p>
                    
                    <!-- Author -->
                    <div class="flex items-center gap-4">
                        <div class="w-12 h-12 rounded-full bg-gradient-to-br from-purple-500 to-indigo-600 flex items-center justify-center text-white font-bold">
                            {{ substr($testimonial['author'], 0, 1) }}
                        </div>
                        <div>
                            <div class="font-semibold text-gray-900">{{ $testimonial['author'] }}</div>
                            <div class="text-sm text-gray-500">{{ $testimonial['role'] }}, {{ $testimonial['company'] }}</div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    
    <!-- Custom CSS for Animation -->
    <style>
        @keyframes scroll {
            0% {
                transform: translateX(0);
            }
            100% {
                transform: translateX(-50%);
            }
        }
        
        .animate-scroll {
            display: flex;
        }
        
        .animate-scroll:hover {
            animation-play-state: paused;
        }
    </style>
</section>

<!-- Pricing Section -->
<section id="pricing" class="py-24 bg-[#f5f1e8]">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="max-w-3xl mx-auto text-center mb-12">
            <div class="inline-block px-4 py-1.5 text-sm font-medium text-gray-600 bg-white rounded-full mb-6">Pricing</div>
            <h2 class="text-3xl sm:text-4xl lg:text-5xl font-bold text-gray-900 mb-4">
                Affordable prices and scalable plans <span class="text-[#0a3d3d]">to fit any business size</span>
            </h2>
        </div>
        
        <!-- Toggle -->
        <div class="flex items-center justify-center gap-3 mb-12" x-data="{ billingPeriod: 'monthly' }">
            <button 
                @click="billingPeriod = 'monthly'"
                :class="billingPeriod === 'monthly' ? 'bg-[#84cc16] text-[#0a3d3d]' : 'bg-white text-gray-700'"
                class="px-6 py-2.5 rounded-lg font-semibold transition-all duration-300"
            >
                Pay monthly
            </button>
            <button 
                @click="billingPeriod = 'yearly'"
                :class="billingPeriod === 'yearly' ? 'bg-[#84cc16] text-[#0a3d3d]' : 'bg-white text-gray-700'"
                class="px-6 py-2.5 rounded-lg font-semibold transition-all duration-300"
            >
                Pay yearly
            </button>
        </div>
        
        <!-- Pricing Cards -->
        <div class="grid md:grid-cols-3 gap-6 max-w-6xl mx-auto">
            <!-- Starter Plan -->
            <div class="bg-white rounded-2xl p-8 shadow-sm hover:shadow-lg transition-all duration-300">
                <h3 class="text-xl font-bold text-gray-900 mb-2">Starter</h3>
                <p class="text-sm text-gray-600 mb-6">For individuals, freelancers</p>
                
                <div class="mb-6">
                    <span class="text-5xl font-bold text-gray-900">$49</span>
                    <span class="text-gray-500 text-sm">/ month</span>
                    <div class="text-xs text-gray-500 mt-1">Billed once monthly</div>
                </div>
                
                <div class="mb-8">
                    <div class="font-semibold text-gray-900 mb-4">Standout features</div>
                    <ul class="space-y-3">
                        <li class="flex items-start gap-3">
                            <svg class="w-5 h-5 text-[#84cc16] flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                            <span class="text-sm text-gray-700">Fast and Reliable</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <svg class="w-5 h-5 text-[#84cc16] flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                            <span class="text-sm text-gray-700">Discover Data Everywhere</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <svg class="w-5 h-5 text-gray-300 flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/></svg>
                            <span class="text-sm text-gray-400">Enrich Data with Context</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <svg class="w-5 h-5 text-gray-300 flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/></svg>
                            <span class="text-sm text-gray-400">Risk Management</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <svg class="w-5 h-5 text-gray-300 flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/></svg>
                            <span class="text-sm text-gray-400">Privacy Compliance</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <svg class="w-5 h-5 text-gray-300 flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/></svg>
                            <span class="text-sm text-gray-400">Third-Party Management</span>
                        </li>
                    </ul>
                </div>
                
                <button class="w-full py-3 px-6 bg-gray-100 text-gray-900 font-semibold rounded-lg hover:bg-gray-200 transition-colors mb-2">
                    Try for free
                </button>
                <p class="text-xs text-center text-gray-500">No credit card required!</p>
            </div>
            
            <!-- Pro Plan (Popular) -->
            <div class="bg-white rounded-2xl p-8 shadow-lg hover:shadow-xl transition-all duration-300 border-2 border-[#84cc16]">
                <h3 class="text-xl font-bold text-gray-900 mb-2">Pro</h3>
                <p class="text-sm text-gray-600 mb-6">For startups, agencies</p>
                
                <div class="mb-6">
                    <span class="text-5xl font-bold text-gray-900">$89</span>
                    <span class="text-gray-500 text-sm">/ month</span>
                    <div class="text-xs text-gray-500 mt-1">Billed once monthly</div>
                </div>
                
                <div class="mb-8">
                    <div class="font-semibold text-gray-900 mb-4">Standout features</div>
                    <ul class="space-y-3">
                        <li class="flex items-start gap-3">
                            <svg class="w-5 h-5 text-[#84cc16] flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                            <span class="text-sm text-gray-700">Fast and Reliable</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <svg class="w-5 h-5 text-[#84cc16] flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                            <span class="text-sm text-gray-700">Discover Data Everywhere</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <svg class="w-5 h-5 text-[#84cc16] flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                            <span class="text-sm text-gray-700">Enrich Data with Context</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <svg class="w-5 h-5 text-[#84cc16] flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                            <span class="text-sm text-gray-700">Risk Management</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <svg class="w-5 h-5 text-gray-300 flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/></svg>
                            <span class="text-sm text-gray-400">Privacy Compliance</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <svg class="w-5 h-5 text-gray-300 flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/></svg>
                            <span class="text-sm text-gray-400">Third-Party Management</span>
                        </li>
                    </ul>
                </div>
                
                <button class="w-full py-3 px-6 bg-[#84cc16] text-[#0a3d3d] font-semibold rounded-lg hover:bg-[#73b512] transition-colors mb-2">
                    Try for free
                </button>
                <p class="text-xs text-center text-gray-500">No credit card required!</p>
            </div>
            
            <!-- Business Plan -->
            <div class="bg-white rounded-2xl p-8 shadow-sm hover:shadow-lg transition-all duration-300">
                <h3 class="text-xl font-bold text-gray-900 mb-2">Business</h3>
                <p class="text-sm text-gray-600 mb-6">For large business, companies</p>
                
                <div class="mb-6">
                    <span class="text-5xl font-bold text-gray-900">$249</span>
                    <span class="text-gray-500 text-sm">/ month</span>
                    <div class="text-xs text-gray-500 mt-1">Billed once monthly</div>
                </div>
                
                <div class="mb-8">
                    <div class="font-semibold text-gray-900 mb-4">Standout features</div>
                    <ul class="space-y-3">
                        <li class="flex items-start gap-3">
                            <svg class="w-5 h-5 text-[#84cc16] flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                            <span class="text-sm text-gray-700">Fast and Reliable</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <svg class="w-5 h-5 text-[#84cc16] flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                            <span class="text-sm text-gray-700">Discover Data Everywhere</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <svg class="w-5 h-5 text-[#84cc16] flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                            <span class="text-sm text-gray-700">Enrich Data with Context</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <svg class="w-5 h-5 text-[#84cc16] flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                            <span class="text-sm text-gray-700">Risk Management</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <svg class="w-5 h-5 text-[#84cc16] flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                            <span class="text-sm text-gray-700">Privacy Compliance</span>
                        </li>
                        <li class="flex items-start gap-3">
                            <svg class="w-5 h-5 text-[#84cc16] flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                            <span class="text-sm text-gray-700">Third-Party Management</span>
                        </li>
                    </ul>
                </div>
                
                <button class="w-full py-3 px-6 bg-gray-100 text-gray-900 font-semibold rounded-lg hover:bg-gray-200 transition-colors mb-2">
                    Get in touch
                </button>
                <p class="text-xs text-center text-gray-500 invisible">Placeholder</p>
            </div>
        </div>
    </div>
</section>

<!-- FAQ Section -->
<section class="py-24 bg-white">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="max-w-3xl mx-auto">
            <div class="text-center mb-16">
                <span class="inline-block px-4 py-1.5 text-sm font-semibold text-purple-700 bg-purple-100 rounded-full mb-4">FAQ</span>
                <h2 class="text-3xl sm:text-4xl font-bold text-gray-900 mb-6">Frequently asked questions</h2>
                <p class="text-lg text-gray-600">Everything you need to know about the platform.</p>
            </div>
            
            <div class="space-y-4" x-data="{ openFaq: null }">
                @foreach($faqs as $index => $faq)
                <div class="border border-gray-200 rounded-xl overflow-hidden hover:border-purple-300 transition-colors">
                    <button 
                        @click="openFaq = openFaq === {{ $index }} ? null : {{ $index }}"
                        class="flex items-center justify-between w-full p-6 text-left bg-white hover:bg-gray-50 transition-colors"
                    >
                        <span class="font-semibold text-gray-900 pr-4">{{ $faq['question'] }}</span>
                        <i data-lucide="chevron-down" class="w-5 h-5 text-gray-500 transition-transform duration-300" :class="{ 'rotate-180': openFaq === {{ $index }} }"></i>
                    </button>
                    <div 
                        x-show="openFaq === {{ $index }}"
                        x-collapse
                        class="px-6 pb-6"
                    >
                        <p class="text-gray-600 leading-relaxed">{{ $faq['answer'] }}</p>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-24 bg-gradient-to-br from-purple-600 via-indigo-600 to-purple-700 relative overflow-hidden">
    <!-- Background Pattern -->
    <div class="absolute inset-0 opacity-10">
        <div class="absolute inset-0 bg-[url('data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNjAiIGhlaWdodD0iNjAiIHZpZXdCb3g9IjAgMCA2MCA2MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48ZyBmaWxsPSJub25lIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPjxwYXRoIGQ9Ik0zNiAxOGMzLjMxNCAwIDYgMi42ODYgNiA2cy0yLjY4NiA2LTYgNi02LTIuNjg2LTYtNiAyLjY4Ni02IDYtNiIgc3Ryb2tlPSIjZmZmIiBzdHJva2Utd2lkdGg9IjIiLz48L2c+PC9zdmc+')]"></div>
    </div>
    
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        <div class="max-w-3xl mx-auto text-center">
            <h2 class="text-3xl sm:text-4xl lg:text-5xl font-bold text-white mb-6">Ready to transform your email marketing?</h2>
            <p class="text-xl text-white/80 mb-10">Join thousands of marketers who have already made the switch. Start your free trial today.</p>
            
            <div class="flex flex-col sm:flex-row items-center justify-center gap-4">
                <a href="{{ route('register') }}" class="group inline-flex items-center justify-center px-8 py-4 text-lg font-semibold text-purple-700 bg-white rounded-xl hover:bg-gray-100 transition-all duration-300 hover:scale-105 hover:shadow-2xl">
                    Start Free Trial
                    <i data-lucide="arrow-right" class="w-5 h-5 ml-2 group-hover:translate-x-1 transition-transform"></i>
                </a>
                <a href="#" class="inline-flex items-center justify-center px-8 py-4 text-lg font-semibold text-white border-2 border-white/30 rounded-xl hover:bg-white/10 hover:border-white/50 transition-all duration-300">
                    Contact Sales
                </a>
            </div>
            
            <p class="mt-8 text-white/60 text-sm">No credit card required. 14-day free trial.</p>
        </div>
    </div>
</section>
@endsection

@push('styles')
<style>
    @keyframes fade-in-up {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    .animate-fade-in-up {
        animation: fade-in-up 0.6s ease-out forwards;
        opacity: 0;
    }
</style>
@endpush

@push('scripts')
<script defer src="https://cdn.jsdelivr.net/npm/@alpinejs/collapse@3.x.x/dist/cdn.min.js"></script>
@endpush
