@extends('layouts.customer')

@section('title', $trackingDomain->domain)
@section('page-title', $trackingDomain->domain)

@section('content')
<div class="space-y-6">
    <div class="flex items-center justify-between">
        <div>
            <h2 class="text-2xl font-bold text-gray-900 dark:text-gray-100">{{ $trackingDomain->domain }}</h2>
            <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                Status: <span class="px-2 py-1 text-xs rounded-full {{ $trackingDomain->status === 'verified' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">{{ ucfirst($trackingDomain->status) }}</span>
            </p>
        </div>
        <div class="flex items-center gap-3">
            @if($trackingDomain->customer_id)
                @customercan('domains.tracking_domains.permissions.can_edit_tracking_domains')
                    @if($trackingDomain->status !== 'verified')
                        <form method="POST" action="{{ route('customer.tracking-domains.verify', $trackingDomain) }}">
                            @csrf
                            <x-button type="submit" variant="primary">Verify Domain</x-button>
                        </form>
                        <form method="POST" action="{{ route('customer.tracking-domains.mark-verified', $trackingDomain) }}">
                            @csrf
                            <x-button type="submit" variant="secondary">Mark Verified</x-button>
                        </form>
                    @endif
                    <x-button href="{{ route('customer.tracking-domains.edit', $trackingDomain) }}" variant="secondary">Edit</x-button>
                @endcustomercan
            @endif
        </div>
    </div>

    <x-card title="Domain Information">
        <dl class="grid grid-cols-1 gap-x-4 gap-y-6 sm:grid-cols-2">
            <div>
                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Domain</dt>
                <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $trackingDomain->domain }}</dd>
            </div>
            <div>
                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Status</dt>
                <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">
                    <span class="px-2 py-1 text-xs rounded-full {{ $trackingDomain->status === 'verified' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">{{ ucfirst($trackingDomain->status) }}</span>
                </dd>
            </div>
            <div>
                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Verified At</dt>
                <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $trackingDomain->verified_at ? $trackingDomain->verified_at->format('M d, Y H:i') : 'Not verified' }}</dd>
            </div>
            @if($trackingDomain->verification_token)
                <div class="sm:col-span-2">
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Verification Token</dt>
                    <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100 font-mono bg-gray-100 dark:bg-gray-700 p-2 rounded">{{ $trackingDomain->verification_token }}</dd>
                </div>
            @endif
            @if($trackingDomain->notes)
                <div class="sm:col-span-2">
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Notes</dt>
                    <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $trackingDomain->notes }}</dd>
                </div>
            @endif
        </dl>
    </x-card>
</div>
@endsection

