@extends('layouts.customer')

@section('title', 'List Settings')
@section('page-title', 'Settings: ' . $list->name)

@section('content')
<div class="max-w-4xl">
    <x-card title="Email List Settings">
        <form method="POST" action="{{ route('customer.lists.settings.update', $list) }}" class="space-y-6">
            @csrf
            @method('PUT')

            <!-- From Settings -->
            <div class="space-y-4">
                <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100">From Settings</h3>
                
                <div class="grid grid-cols-1 gap-6 sm:grid-cols-2">
                    <div>
                        <label for="from_name" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                            From Name
                        </label>
                        <input
                            type="text"
                            name="from_name"
                            id="from_name"
                            value="{{ old('from_name', $list->from_name) }}"
                            class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                        >
                        @error('from_name')
                            <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="from_email" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                            From Email
                        </label>
                        <input
                            type="email"
                            name="from_email"
                            id="from_email"
                            value="{{ old('from_email', $list->from_email) }}"
                            class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                        >
                        @error('from_email')
                            <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="reply_to" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                            Reply To Email
                        </label>
                        <input
                            type="email"
                            name="reply_to"
                            id="reply_to"
                            value="{{ old('reply_to', $list->reply_to) }}"
                            class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                        >
                        @error('reply_to')
                            <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="default_subject" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                            Default Subject
                        </label>
                        <input
                            type="text"
                            name="default_subject"
                            id="default_subject"
                            value="{{ old('default_subject', $list->default_subject) }}"
                            class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                        >
                        @error('default_subject')
                            <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="border-t border-gray-200 dark:border-gray-700 pt-6">
                <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100 mb-4">Opt-in Settings</h3>
                
                <div class="flex items-center">
                    <input
                        id="double_opt_in"
                        name="double_opt_in"
                        type="checkbox"
                        value="1"
                        {{ old('double_opt_in', $list->double_opt_in) ? 'checked' : '' }}
                        class="h-4 w-4 text-primary-600 focus:ring-primary-500 border-gray-300 rounded"
                    >
                    <label for="double_opt_in" class="ml-2 block text-sm text-gray-900 dark:text-gray-300">
                        Enable Double Opt-in (Requires email confirmation)
                    </label>
                </div>
            </div>

            <div class="border-t border-gray-200 dark:border-gray-700 pt-6">
                <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100 mb-4">Company Information</h3>
                
                <div class="grid grid-cols-1 gap-6">
                    <div>
                        <label for="company_name" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                            Company Name
                        </label>
                        <input
                            type="text"
                            name="company_name"
                            id="company_name"
                            value="{{ old('company_name', $list->company_name) }}"
                            class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                        >
                    </div>

                    <div>
                        <label for="company_address" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                            Company Address (for compliance)
                        </label>
                        <textarea
                            name="company_address"
                            id="company_address"
                            rows="3"
                            class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                        >{{ old('company_address', $list->company_address) }}</textarea>
                    </div>

                    <div>
                        <label for="footer_text" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                            Footer Text (Auto-added to emails)
                        </label>
                        <textarea
                            name="footer_text"
                            id="footer_text"
                            rows="3"
                            class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                        >{{ old('footer_text', $list->footer_text) }}</textarea>
                    </div>
                </div>
            </div>

            <div class="border-t border-gray-200 dark:border-gray-700 pt-6">
                <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100 mb-4">Welcome Email</h3>
                
                <div class="space-y-4">
                    <div class="flex items-center">
                        <input
                            id="welcome_email_enabled"
                            name="welcome_email_enabled"
                            type="checkbox"
                            value="1"
                            {{ old('welcome_email_enabled', $list->welcome_email_enabled) ? 'checked' : '' }}
                            class="h-4 w-4 text-primary-600 focus:ring-primary-500 border-gray-300 rounded"
                        >
                        <label for="welcome_email_enabled" class="ml-2 block text-sm text-gray-900 dark:text-gray-300">
                            Send welcome email to new subscribers
                        </label>
                    </div>

                    <div>
                        <label for="welcome_email_subject" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                            Welcome Email Subject
                        </label>
                        <input
                            type="text"
                            name="welcome_email_subject"
                            id="welcome_email_subject"
                            value="{{ old('welcome_email_subject', $list->welcome_email_subject) }}"
                            class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                        >
                    </div>

                    <div>
                        <label for="welcome_email_content" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                            Welcome Email Content
                        </label>
                        <textarea
                            name="welcome_email_content"
                            id="welcome_email_content"
                            rows="5"
                            class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                        >{{ old('welcome_email_content', $list->welcome_email_content) }}</textarea>
                    </div>
                </div>
            </div>

            <div class="border-t border-gray-200 dark:border-gray-700 pt-6">
                <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100 mb-4">Unsubscribe Settings</h3>
                
                <div class="space-y-4">
                    <div class="flex items-center">
                        <input
                            id="unsubscribe_email_enabled"
                            name="unsubscribe_email_enabled"
                            type="checkbox"
                            value="1"
                            {{ old('unsubscribe_email_enabled', $list->unsubscribe_email_enabled) ? 'checked' : '' }}
                            class="h-4 w-4 text-primary-600 focus:ring-primary-500 border-gray-300 rounded"
                        >
                        <label for="unsubscribe_email_enabled" class="ml-2 block text-sm text-gray-900 dark:text-gray-300">
                            Send unsubscribe confirmation email
                        </label>
                    </div>

                    <div>
                        <label for="unsubscribe_redirect_url" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                            Unsubscribe Redirect URL
                        </label>
                        <input
                            type="url"
                            name="unsubscribe_redirect_url"
                            id="unsubscribe_redirect_url"
                            value="{{ old('unsubscribe_redirect_url', $list->unsubscribe_redirect_url) }}"
                            placeholder="https://example.com/unsubscribed"
                            class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                        >
                        <p class="mt-1 text-sm text-gray-500">Where to redirect users after they unsubscribe</p>
                    </div>
                </div>
            </div>

            <div class="border-t border-gray-200 dark:border-gray-700 pt-6">
                <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100 mb-4">GDPR Compliance</h3>
                
                <div class="space-y-4">
                    <div class="flex items-center">
                        <input
                            id="gdpr_enabled"
                            name="gdpr_enabled"
                            type="checkbox"
                            value="1"
                            {{ old('gdpr_enabled', $list->gdpr_enabled) ? 'checked' : '' }}
                            class="h-4 w-4 text-primary-600 focus:ring-primary-500 border-gray-300 rounded"
                        >
                        <label for="gdpr_enabled" class="ml-2 block text-sm text-gray-900 dark:text-gray-300">
                            Enable GDPR compliance checkbox
                        </label>
                    </div>

                    <div>
                        <label for="gdpr_text" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                            GDPR Text
                        </label>
                        <textarea
                            name="gdpr_text"
                            id="gdpr_text"
                            rows="3"
                            class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                            placeholder="I agree to the processing of my personal data..."
                        >{{ old('gdpr_text', $list->gdpr_text) }}</textarea>
                    </div>
                </div>
            </div>

            <div class="flex items-center justify-end gap-3 pt-4 border-t border-gray-200 dark:border-gray-700">
                <a href="{{ route('customer.lists.show', $list) }}" class="px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-md shadow-sm hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-600 dark:hover:bg-gray-600">
                    Cancel
                </a>
                <button type="submit" class="px-4 py-2 text-sm font-medium text-white bg-primary-600 border border-transparent rounded-md shadow-sm hover:bg-primary-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500">
                    Save Settings
                </button>
            </div>
        </form>
    </x-card>
</div>
@endsection

