@extends('layouts.customer')

@section('title', 'Edit Subscription Form')
@section('page-title', 'Edit Subscription Form: ' . $form->name)

@section('content')
<div class="max-w-2xl">
    <x-card title="Edit Subscription Form">
        <form method="POST" action="{{ route('customer.lists.forms.update', [$list, $form]) }}" class="space-y-6">
            @csrf
            @method('PUT')

            <div class="grid grid-cols-1 gap-6">
                <div>
                    <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                        Form Name <span class="text-red-500">*</span>
                    </label>
                    <input
                        type="text"
                        name="name"
                        id="name"
                        value="{{ old('name', $form->name) }}"
                        required
                        class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                    >
                    @error('name')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="title" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                        Form Title (public)
                    </label>
                    <input
                        type="text"
                        name="title"
                        id="title"
                        value="{{ old('title', $form->title) }}"
                        class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                    >
                    @error('title')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="type" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                        Form Type <span class="text-red-500">*</span>
                    </label>
                    <select
                        name="type"
                        id="type"
                        required
                        class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                    >
                        <option value="embedded" {{ old('type', $form->type) === 'embedded' ? 'selected' : '' }}>Embedded HTML Form</option>
                        <option value="popup" {{ old('type', $form->type) === 'popup' ? 'selected' : '' }}>Popup</option>
                        <option value="api" {{ old('type', $form->type) === 'api' ? 'selected' : '' }}>API Endpoint</option>
                    </select>
                    @error('type')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                        Description
                    </label>
                    <textarea
                        name="description"
                        id="description"
                        rows="3"
                        class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                    >{{ old('description', $form->description) }}</textarea>
                    @error('description')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                        Display Options
                    </label>
                    <div class="space-y-2">
                        <label class="flex items-center">
                            <input type="hidden" name="settings[show_title]" value="0">
                            <input
                                type="checkbox"
                                name="settings[show_title]"
                                value="1"
                                {{ old('settings.show_title', data_get($form->settings, 'show_title', true)) ? 'checked' : '' }}
                                class="rounded border-gray-300 text-primary-600 focus:ring-primary-500"
                            >
                            <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">Show form title</span>
                        </label>
                        <label class="flex items-center">
                            <input type="hidden" name="settings[show_description]" value="0">
                            <input
                                type="checkbox"
                                name="settings[show_description]"
                                value="1"
                                {{ old('settings.show_description', data_get($form->settings, 'show_description', true)) ? 'checked' : '' }}
                                class="rounded border-gray-300 text-primary-600 focus:ring-primary-500"
                            >
                            <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">Show form description</span>
                        </label>
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                        Form Fields
                    </label>
                    <div class="space-y-2">
                        <label class="flex items-center">
                            <input type="checkbox" name="fields[]" value="email" {{ in_array('email', old('fields', $form->fields ?? [])) ? 'checked' : '' }} class="rounded border-gray-300 text-primary-600 focus:ring-primary-500">
                            <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">Email (required)</span>
                        </label>
                        <label class="flex items-center">
                            <input type="checkbox" name="fields[]" value="first_name" {{ in_array('first_name', old('fields', $form->fields ?? [])) ? 'checked' : '' }} class="rounded border-gray-300 text-primary-600 focus:ring-primary-500">
                            <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">First Name</span>
                        </label>
                        <label class="flex items-center">
                            <input type="checkbox" name="fields[]" value="last_name" {{ in_array('last_name', old('fields', $form->fields ?? [])) ? 'checked' : '' }} class="rounded border-gray-300 text-primary-600 focus:ring-primary-500">
                            <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">Last Name</span>
                        </label>
                    </div>
                </div>

                <div class="flex items-center">
                    <input
                        id="gdpr_checkbox"
                        name="gdpr_checkbox"
                        type="checkbox"
                        value="1"
                        {{ old('gdpr_checkbox', $form->gdpr_checkbox) ? 'checked' : '' }}
                        class="h-4 w-4 text-primary-600 focus:ring-primary-500 border-gray-300 rounded"
                    >
                    <label for="gdpr_checkbox" class="ml-2 block text-sm text-gray-900 dark:text-gray-300">
                        Show GDPR compliance checkbox
                    </label>
                </div>

                <div>
                    <label for="gdpr_text" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                        GDPR Text
                    </label>
                    <textarea
                        name="gdpr_text"
                        id="gdpr_text"
                        rows="2"
                        class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                        placeholder="I agree to the processing of my personal data..."
                    >{{ old('gdpr_text', $form->gdpr_text) }}</textarea>
                </div>

                <div class="flex items-center">
                    <input
                        id="is_active"
                        name="is_active"
                        type="checkbox"
                        value="1"
                        {{ old('is_active', $form->is_active) ? 'checked' : '' }}
                        class="h-4 w-4 text-primary-600 focus:ring-primary-500 border-gray-300 rounded"
                    >
                    <label for="is_active" class="ml-2 block text-sm text-gray-900 dark:text-gray-300">
                        Form is active
                    </label>
                </div>
            </div>

            <div class="flex items-center justify-end gap-3 pt-4 border-t border-gray-200 dark:border-gray-700">
                <a href="{{ route('customer.lists.forms.show', [$list, $form]) }}" class="px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-md shadow-sm hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-600 dark:hover:bg-gray-600">
                    Cancel
                </a>
                <button type="submit" class="px-4 py-2 text-sm font-medium text-white bg-primary-600 border border-transparent rounded-md shadow-sm hover:bg-primary-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500">
                    Update Form
                </button>
            </div>
        </form>
    </x-card>
</div>
@endsection

