@extends('layouts.customer')

@section('title', 'Create Campaign')
@section('page-title', 'Create Campaign')

@section('content')
<div class="max-w-4xl">
    @if(!empty($runPreflightIssues))
        <div class="mb-6 p-4 bg-yellow-50 border border-yellow-200 text-yellow-900 rounded-lg dark:bg-yellow-900/20 dark:border-yellow-800 dark:text-yellow-100">
            <div class="flex items-start">
                <svg class="w-5 h-5 mr-2 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                </svg>
                <div class="flex-1">
                    <h3 class="text-sm font-semibold mb-1">Action required before you can run campaigns</h3>
                    <ul class="text-sm list-disc list-inside space-y-1">
                        @foreach($runPreflightIssues as $issue)
                            <li>{{ $issue }}</li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    @endif
    <x-card title="Campaign Information">
        <form method="POST" action="{{ route('customer.campaigns.store') }}" class="space-y-6">
            @csrf

            <div class="grid grid-cols-1 gap-6 sm:grid-cols-2">
                <div class="sm:col-span-2">
                    <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                        Campaign Name <span class="text-red-500">*</span>
                    </label>
                    <input
                        type="text"
                        name="name"
                        id="name"
                        value="{{ old('name') }}"
                        required
                        class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                    >
                    @error('name')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div class="sm:col-span-2">
                    <label for="subject" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                        Subject <span class="text-red-500">*</span>
                    </label>
                    <input
                        type="text"
                        name="subject"
                        id="subject"
                        value="{{ old('subject') }}"
                        required
                        class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                    >
                    @error('subject')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="list_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                        Email List
                    </label>
                    <select
                        name="list_id"
                        id="list_id"
                        class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                    >
                        <option value="">Select a list...</option>
                        @foreach($emailLists as $list)
                            <option value="{{ $list->id }}" {{ old('list_id') == $list->id ? 'selected' : '' }}>
                                {{ $list->name }}
                            </option>
                        @endforeach
                    </select>
                    @error('list_id')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="type" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                        Type
                    </label>
                    <select
                        name="type"
                        id="type"
                        class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                    >
                        <option value="regular" {{ old('type') == 'regular' ? 'selected' : '' }}>Regular</option>
                        <option value="autoresponder" {{ old('type') == 'autoresponder' ? 'selected' : '' }}>Auto Responder</option>
                        <option value="recurring" {{ old('type') == 'recurring' ? 'selected' : '' }}>Recurring</option>
                    </select>
                    @error('type')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="delivery_server_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                        Delivery Server
                    </label>
                    <select
                        name="delivery_server_id"
                        id="delivery_server_id"
                        class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                    >
                        <option value="">Use Default (Auto-select)</option>
                        @foreach($deliveryServers as $server)
                            <option value="{{ $server->id }}" {{ old('delivery_server_id') == $server->id ? 'selected' : '' }}>
                                {{ $server->name }} ({{ ucfirst($server->type) }})
                            </option>
                        @endforeach
                    </select>
                    <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                        Select a delivery server for this campaign. If not selected, the system will auto-select an active server.
                    </p>
                    @error('delivery_server_id')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="reply_server_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                        Reply Server
                    </label>
                    <select
                        name="reply_server_id"
                        id="reply_server_id"
                        class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                    >
                        <option value="">Use Default (Env / Disabled)</option>
                        @foreach($replyServers as $server)
                            <option value="{{ $server->id }}" {{ old('reply_server_id') == $server->id ? 'selected' : '' }}>
                                {{ $server->name }}
                            </option>
                        @endforeach
                    </select>
                    <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                        Select a reply tracking server for this campaign. If not selected, reply tracking uses the global configuration.
                    </p>
                    @error('reply_server_id')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="sending_domain_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                        Sending Domain
                    </label>
                    <select
                        name="sending_domain_id"
                        id="sending_domain_id"
                        class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                    >
                        <option value="">Use Email List's Sending Domain (or Default)</option>
                        @foreach($sendingDomains as $domain)
                            <option value="{{ $domain->id }}" {{ old('sending_domain_id') == $domain->id ? 'selected' : '' }}>
                                {{ $domain->domain }} {{ $domain->status === 'verified' ? '✓' : '' }}
                            </option>
                        @endforeach
                    </select>
                    <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                        Select a verified sending domain for this campaign. If not selected, the email list's sending domain will be used.
                    </p>
                    @error('sending_domain_id')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="tracking_domain_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                        Tracking Domain
                    </label>
                    <select
                        name="tracking_domain_id"
                        id="tracking_domain_id"
                        class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                    >
                        <option value="">Use Default (App Domain)</option>
                        @foreach($trackingDomains as $domain)
                            <option value="{{ $domain->id }}" {{ old('tracking_domain_id') == $domain->id ? 'selected' : '' }}>
                                {{ $domain->domain }} {{ $domain->status === 'verified' ? '✓' : '' }}
                            </option>
                        @endforeach
                    </select>
                    <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                        Select a verified tracking domain for opens/clicks tracking.
                    </p>
                    @error('tracking_domain_id')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="from_name" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                        From Name
                    </label>
                    <input
                        type="text"
                        name="from_name"
                        id="from_name"
                        value="{{ old('from_name') }}"
                        class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                    >
                    @error('from_name')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="from_email" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                        From Email
                    </label>
                    <input
                        type="email"
                        name="from_email"
                        id="from_email"
                        value="{{ old('from_email', auth('customer')->user()->email) }}"
                        class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                    >
                    @error('from_email')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div class="sm:col-span-2">
                    <label for="template_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                        Email Template
                    </label>
                    <select
                        name="template_id"
                        id="template_id"
                        class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                    >
                        <option value="">Select a template...</option>
                        @foreach($templates as $template)
                            <option value="{{ $template->id }}" {{ old('template_id') == $template->id ? 'selected' : '' }}>
                                {{ $template->name }} ({{ ucfirst($template->type) }})
                            </option>
                        @endforeach
                    </select>
                    <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                        Select a template to use for this campaign.
                        @customercan('templates.permissions.can_create_templates')
                            You can also <a href="{{ route('customer.templates.unlayer.create') }}" target="_blank" class="text-primary-600 hover:text-primary-700">create a new template</a>.
                        @endcustomercan
                    </p>
                    @error('template_id')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <input type="hidden" name="html_content" id="html_content" value="{{ old('html_content') }}">
                <input type="hidden" name="plain_text_content" id="plain_text_content" value="{{ old('plain_text_content') }}">

                <div class="sm:col-span-2">
                    <div x-data="{ tab: 'design' }" class="space-y-3">
                        <div class="flex items-center gap-6 border-b border-gray-200 dark:border-gray-700">
                            <button type="button" @click="tab = 'design'" class="py-3 text-sm font-medium" :class="tab === 'design' ? 'text-primary-600 border-b-2 !border-primary-600' : 'text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200'">
                                Design
                            </button>
                            <button type="button" @click="tab = 'json'" class="py-3 text-sm font-medium" :class="tab === 'json' ? 'text-primary-600 border-b-2 !border-primary-600' : 'text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200'">
                                JSON
                            </button>
                            <button type="button" @click="tab = 'html'" class="py-3 text-sm font-medium" :class="tab === 'html' ? 'text-primary-600 border-b-2 !border-primary-600' : 'text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200'">
                                HTML
                            </button>
                        </div>

                        <div x-show="tab === 'design'" class="border border-gray-200 dark:border-gray-700 rounded-lg p-4 bg-white">
                            <iframe
                                id="campaign_preview_iframe"
                                srcdoc="{!! htmlspecialchars(old('html_content', '<p>No content</p>'), ENT_QUOTES, 'UTF-8') !!}"
                                class="w-full h-[600px] border-0"
                                style="min-height: 600px;"
                                loading="lazy"
                                sandbox
                            ></iframe>
                        </div>

                        <div x-show="tab === 'json'" class="border border-gray-200 dark:border-gray-700 rounded-lg bg-white p-4">
                            <textarea id="campaign_preview_json" readonly class="w-full h-[600px] border-0 bg-transparent text-xs font-mono text-gray-800 dark:text-gray-100 resize-none focus:outline-none"></textarea>
                        </div>

                        <div x-show="tab === 'html'" class="border border-gray-200 dark:border-gray-700 rounded-lg bg-white p-4">
                            <textarea id="campaign_preview_html" readonly class="w-full h-[600px] border-0 bg-transparent text-xs font-mono text-gray-800 dark:text-gray-100 resize-none focus:outline-none">{{ old('html_content') }}</textarea>
                        </div>
                    </div>
                </div>

                <div>
                    <label for="send_at" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                        Send At (Optional)
                    </label>
                    <input
                        type="datetime-local"
                        name="send_at"
                        id="send_at"
                        value="{{ old('send_at') }}"
                        class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-700 dark:text-gray-100 sm:text-sm"
                    >
                    @error('send_at')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div class="sm:col-span-2">
                    <div class="flex items-center space-x-6">
                        <label class="flex items-center">
                            <input
                                type="checkbox"
                                name="track_opens"
                                value="1"
                                {{ old('track_opens', true) ? 'checked' : '' }}
                                class="rounded border-gray-300 text-primary-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:border-gray-600 dark:bg-gray-700"
                            >
                            <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">Track Opens</span>
                        </label>
                        <label class="flex items-center">
                            <input
                                type="checkbox"
                                name="track_clicks"
                                value="1"
                                {{ old('track_clicks', true) ? 'checked' : '' }}
                                class="rounded border-gray-300 text-primary-600 shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:border-gray-600 dark:bg-gray-700"
                            >
                            <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">Track Clicks</span>
                        </label>
                    </div>
                </div>
            </div>

            <div class="flex items-center justify-end gap-3 pt-4 border-t border-gray-200 dark:border-gray-700">
                <x-button href="{{ route('customer.campaigns.index') }}" variant="secondary">Cancel</x-button>
                @customercan('campaigns.permissions.can_create_campaigns')
                    <x-button type="submit" variant="primary">Create Campaign</x-button>
                @endcustomercan
            </div>
        </form>
    </x-card>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const templateSelect = document.getElementById('template_id');
    const htmlContent = document.getElementById('html_content');
    const plainTextContent = document.getElementById('plain_text_content');
    const previewIframe = document.getElementById('campaign_preview_iframe');
    const previewJson = document.getElementById('campaign_preview_json');
    const previewHtml = document.getElementById('campaign_preview_html');
    const baseUrl = '{{ url("/customer/templates") }}';

    const updatePreviewFromHtml = () => {
        if (!previewIframe || !previewHtml || !htmlContent) {
            return;
        }

        const html = htmlContent.value || '';
        previewIframe.setAttribute('srcdoc', html);
        previewHtml.value = html;
    };

    const updatePreviewJsonValue = (value) => {
        if (!previewJson) {
            return;
        }

        if (value === null || typeof value === 'undefined' || value === '') {
            previewJson.value = '';
            return;
        }

        try {
            previewJson.value = JSON.stringify(value, null, 2);
        } catch (e) {
            previewJson.value = '';
        }
    };

    updatePreviewFromHtml();

    if (templateSelect) {
        templateSelect.addEventListener('change', function() {
            const templateId = this.value;
            
            if (templateId) {
                // Fetch template content
                fetch(`${baseUrl}/${templateId}/content`, {
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json',
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.html_content) {
                        htmlContent.value = data.html_content;
                    }
                    if (data.plain_text_content) {
                        plainTextContent.value = data.plain_text_content;
                    }

                    updatePreviewFromHtml();
                    updatePreviewJsonValue(data.builder_data ?? null);
                })
                .catch(error => {
                    console.error('Error loading template:', error);
                });
            } else {
                // Clear content if no template selected
                htmlContent.value = '';
                plainTextContent.value = '';

                updatePreviewFromHtml();
                updatePreviewJsonValue(null);
            }
        });
    }
});
</script>
@endpush
@endsection

