@extends('layouts.admin')

@section('title', $trackingDomain->domain)
@section('page-title', $trackingDomain->domain)

@section('content')
<div class="space-y-6">
    <div class="flex items-center justify-between">
        <div>
            <h2 class="text-2xl font-bold text-gray-900 dark:text-gray-100">{{ $trackingDomain->domain }}</h2>
            <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                {{ __('Status:') }}
                <span class="px-2 py-1 text-xs rounded-full {{ $trackingDomain->status === 'verified' ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' : 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-200' }}">
                    {{ __(ucfirst($trackingDomain->status)) }}
                </span>
            </p>
        </div>
        <div class="flex items-center gap-3">
            @if($trackingDomain->status !== 'verified')
                <form method="POST" action="{{ route('admin.tracking-domains.verify', $trackingDomain) }}">
                    @csrf
                    <x-button type="submit" variant="primary">{{ __('Verify Domain') }}</x-button>
                </form>
                <form method="POST" action="{{ route('admin.tracking-domains.mark-verified', $trackingDomain) }}">
                    @csrf
                    <x-button type="submit" variant="secondary">{{ __('Mark Verified') }}</x-button>
                </form>
            @endif
            <x-button href="{{ route('admin.tracking-domains.edit', $trackingDomain) }}" variant="secondary">{{ __('Edit') }}</x-button>
            <x-button href="{{ route('admin.tracking-domains.index') }}" variant="secondary">{{ __('Back') }}</x-button>
        </div>
    </div>

    <x-card title="{{ __('Domain Information') }}">
        <dl class="grid grid-cols-1 gap-x-4 gap-y-6 sm:grid-cols-2">
            <div>
                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">{{ __('Domain') }}</dt>
                <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $trackingDomain->domain }}</dd>
            </div>
            <div>
                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">{{ __('Customer') }}</dt>
                <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">
                    @if($trackingDomain->customer)
                        <a href="{{ route('admin.customers.show', $trackingDomain->customer) }}" class="text-primary-600 hover:text-primary-900 dark:text-primary-400 dark:hover:text-primary-300">
                            {{ $trackingDomain->customer->full_name ?? $trackingDomain->customer->email }}
                        </a>
                    @else
                        -
                    @endif
                </dd>
            </div>
            <div>
                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">{{ __('Status') }}</dt>
                <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ __(ucfirst($trackingDomain->status)) }}</dd>
            </div>
            <div>
                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">{{ __('Verified At') }}</dt>
                <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $trackingDomain->verified_at ? $trackingDomain->verified_at->format('M d, Y H:i') : __('Not verified') }}</dd>
            </div>
            <div class="sm:col-span-2">
                <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">{{ __('Verification Token') }}</dt>
                <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100 font-mono break-all">{{ $trackingDomain->verification_token }}</dd>
            </div>
            @if($trackingDomain->notes)
                <div class="sm:col-span-2">
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">{{ __('Notes') }}</dt>
                    <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $trackingDomain->notes }}</dd>
                </div>
            @endif
        </dl>
    </x-card>
</div>
@endsection
