@extends('layouts.admin')

@section('title', $replyServer->name)
@section('page-title', $replyServer->name)

@section('content')
<div class="flex items-center justify-between mb-4">
    <div>
        <h1 class="text-2xl font-semibold text-gray-900 dark:text-gray-100">{{ $replyServer->name }}</h1>
        <p class="text-sm text-gray-500 dark:text-gray-400">{{ __('Reply server details') }}</p>
    </div>
    <div class="space-x-2">
        <x-button href="{{ route('admin.reply-servers.edit', $replyServer) }}" variant="secondary">{{ __('Edit') }}</x-button>
        <form method="POST" action="{{ route('admin.reply-servers.destroy', $replyServer) }}" class="inline" onsubmit="return confirm('{{ __('Delete this reply server?') }}');">
            @csrf
            @method('DELETE')
            <x-button type="submit" variant="danger">{{ __('Delete') }}</x-button>
        </form>
    </div>
</div>

<x-card>
    <dl class="grid grid-cols-1 gap-4 sm:grid-cols-2">
        <div>
            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">{{ __('Protocol') }}</dt>
            <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100 uppercase">{{ $replyServer->protocol }}</dd>
        </div>
        <div>
            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">{{ __('Host') }}</dt>
            <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $replyServer->hostname }}:{{ $replyServer->port }} ({{ strtoupper($replyServer->encryption) }})</dd>
        </div>
        <div>
            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">{{ __('Mailbox') }}</dt>
            <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $replyServer->mailbox ?? __('INBOX') }}</dd>
        </div>
        <div>
            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">{{ __('Username') }}</dt>
            <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $replyServer->username }}</dd>
        </div>
        <div>
            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">{{ __('Reply Domain') }}</dt>
            <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $replyServer->reply_domain ?? __('—') }}</dd>
        </div>
        <div>
            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">{{ __('Active') }}</dt>
            <dd class="mt-1">
                <span class="px-2 py-1 text-xs font-semibold rounded-full {{ $replyServer->active ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' : 'bg-gray-100 text-gray-800 dark:bg-gray-800 dark:text-gray-300' }}">
                    {{ $replyServer->active ? __('Active') : __('Inactive') }}
                </span>
            </dd>
        </div>
        <div>
            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">{{ __('Delete After Processing') }}</dt>
            <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $replyServer->delete_after_processing ? __('Yes') : __('No') }}</dd>
        </div>
        <div>
            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">{{ __('Max Emails Per Batch') }}</dt>
            <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $replyServer->max_emails_per_batch ?? 100 }}</dd>
        </div>
        <div>
            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">{{ __('Notes') }}</dt>
            <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $replyServer->notes ?? __('—') }}</dd>
        </div>
    </dl>
</x-card>
@endsection
