@extends('layouts.admin')

@section('title', __('Edit Email Validation Tool'))
@section('page-title', __('Edit Email Validation Tool'))

@section('content')
<x-card>
    <form method="POST" action="{{ route('admin.email-validation.tools.update', $tool) }}" class="space-y-4">
        @csrf
        @method('PUT')

        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">{{ __('Name') }}</label>
            <input name="name" value="{{ old('name', $tool->name) }}" class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100">
            @error('name')
                <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
            @enderror
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">{{ __('Provider') }}</label>
                <select name="provider" class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100">
                    <option value="snapvalid" {{ old('provider', $tool->provider) === 'snapvalid' ? 'selected' : '' }}>{{ __('Snapvalid') }}</option>
                </select>
                @error('provider')
                    <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">{{ __('API Key (leave blank to keep)') }}</label>
                <input name="api_key" type="password" class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100">
                @error('api_key')
                    <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
            </div>
        </div>

        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">{{ __('Customer Groups') }}</label>
            @php
                $chosenGroups = (array) old('customer_group_ids', $selectedGroupIds ?? []);
                $chosenGroups = array_map('intval', $chosenGroups);
            @endphp
            <select name="customer_group_ids[]" multiple class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100">
                @foreach($customerGroups as $group)
                    <option value="{{ $group->id }}" {{ in_array((int) $group->id, $chosenGroups, true) ? 'selected' : '' }}>{{ $group->name }}</option>
                @endforeach
            </select>
            @error('customer_group_ids')
                <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
            @enderror
            @error('customer_group_ids.*')
                <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
            @enderror
        </div>

        <div class="flex items-center gap-6">
            <label class="inline-flex items-center">
                <input type="hidden" name="active" value="0">
                <input type="checkbox" name="active" value="1" {{ old('active', $tool->active) ? 'checked' : '' }} class="rounded border-gray-300 text-primary-600 shadow-sm focus:ring-primary-500 dark:border-gray-600 dark:bg-gray-700">
                <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">{{ __('Active') }}</span>
            </label>
        </div>

        <div class="flex items-center justify-end gap-3">
            <x-button href="{{ route('admin.email-validation.index') }}" variant="secondary">{{ __('Cancel') }}</x-button>
            @admincan('admin.email_validation.edit')
                <x-button type="submit" variant="primary">{{ __('Save') }}</x-button>
            @endadmincan
        </div>
    </form>
</x-card>
@endsection
