@extends('layouts.admin')

@section('title', __('Add Email Validation Tool'))
@section('page-title', __('Add Email Validation Tool'))

@section('content')
<x-card>
    <form method="POST" action="{{ route('admin.email-validation.tools.store') }}" class="space-y-4">
        @csrf

        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">{{ __('Name') }}</label>
            <input name="name" value="{{ old('name') }}" class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100">
            @error('name')
                <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
            @enderror
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">{{ __('Provider') }}</label>
                <select name="provider" class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100">
                    <option value="snapvalid" {{ old('provider', 'snapvalid') === 'snapvalid' ? 'selected' : '' }}>{{ __('Snapvalid') }}</option>
                </select>
                @error('provider')
                    <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">{{ __('API Key') }}</label>
                <input name="api_key" type="password" class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100">
                @error('api_key')
                    <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
            </div>
        </div>

        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">{{ __('Customer Groups') }}</label>
            <select name="customer_group_ids[]" multiple class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100">
                @foreach($customerGroups as $group)
                    <option value="{{ $group->id }}" {{ in_array((int) $group->id, (array) old('customer_group_ids', []), true) ? 'selected' : '' }}>{{ $group->name }}</option>
                @endforeach
            </select>
            @error('customer_group_ids')
                <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
            @enderror
            @error('customer_group_ids.*')
                <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
            @enderror
        </div>

        <div class="flex items-center gap-6">
            <label class="inline-flex items-center">
                <input type="hidden" name="active" value="0">
                <input type="checkbox" name="active" value="1" {{ old('active', true) ? 'checked' : '' }} class="rounded border-gray-300 text-primary-600 shadow-sm focus:ring-primary-500 dark:border-gray-600 dark:bg-gray-700">
                <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">{{ __('Active') }}</span>
            </label>
        </div>

        <div class="flex items-center justify-end gap-3">
            <x-button href="{{ route('admin.email-validation.index') }}" variant="secondary">{{ __('Cancel') }}</x-button>
            @admincan('admin.email_validation.create')
                <x-button type="submit" variant="primary">{{ __('Save') }}</x-button>
            @endadmincan
        </div>
    </form>
</x-card>
@endsection
