<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Crypt;

class ReplyServer extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'customer_id',
        'name',
        'reply_domain',
        'protocol',
        'hostname',
        'port',
        'encryption',
        'username',
        'password',
        'mailbox',
        'active',
        'delete_after_processing',
        'max_emails_per_batch',
        'notes',
    ];

    protected function casts(): array
    {
        return [
            'active' => 'boolean',
            'delete_after_processing' => 'boolean',
            'port' => 'integer',
            'max_emails_per_batch' => 'integer',
        ];
    }

    public function setPasswordAttribute($value): void
    {
        $this->attributes['password'] = Crypt::encryptString($value);
    }

    public function getPasswordAttribute($value): string
    {
        try {
            return Crypt::decryptString($value);
        } catch (\Exception $e) {
            return $value;
        }
    }

    public function customer(): BelongsTo
    {
        return $this->belongsTo(Customer::class);
    }

    public function isActive(): bool
    {
        return $this->active;
    }
}
