<?php

namespace App\Http\Middleware;

use Illuminate\Auth\Middleware\Authenticate as Middleware;
use Illuminate\Http\Request;

class Authenticate extends Middleware
{
    /**
     * Get the path the user should be redirected to when they are not authenticated.
     */
    protected function redirectTo(Request $request): ?string
    {
        if ($request->expectsJson()) {
            return null;
        }

        // Redirect based on route prefix
        if ($request->is('admin/*')) {
            return route('admin.login');
        }

        if ($request->is('customer/*') || $request->is('account/*')) {
            return route('customer.login');
        }

        // Default fallback - redirect to admin login
        return route('admin.login');
    }
}

