<?php

namespace App\Http\Controllers\Customer;

use App\Http\Controllers\Controller;
use App\Models\EmailList;
use App\Services\EmailListService;
use Illuminate\Http\Request;

class EmailListSettingsController extends Controller
{
    public function __construct(
        protected EmailListService $emailListService
    ) {}

    /**
     * Show the settings form for an email list.
     */
    public function edit(EmailList $list)
    {
        return view('customer.lists.settings', compact('list'));
    }

    /**
     * Update the email list settings.
     */
    public function update(Request $request, EmailList $list)
    {
        $validated = $request->validate([
            'from_name' => ['nullable', 'string', 'max:255'],
            'from_email' => ['nullable', 'email', 'max:255'],
            'reply_to' => ['nullable', 'email', 'max:255'],
            'double_opt_in' => ['nullable', 'boolean'],
            'default_subject' => ['nullable', 'string', 'max:255'],
            'company_name' => ['nullable', 'string', 'max:255'],
            'company_address' => ['nullable', 'string'],
            'footer_text' => ['nullable', 'string'],
            'welcome_email_enabled' => ['nullable', 'boolean'],
            'welcome_email_subject' => ['nullable', 'string', 'max:255'],
            'welcome_email_content' => ['nullable', 'string'],
            'unsubscribe_email_enabled' => ['nullable', 'boolean'],
            'unsubscribe_email_subject' => ['nullable', 'string', 'max:255'],
            'unsubscribe_email_content' => ['nullable', 'string'],
            'unsubscribe_redirect_url' => ['nullable', 'url', 'max:255'],
            'gdpr_enabled' => ['nullable', 'boolean'],
            'gdpr_text' => ['nullable', 'string'],
        ]);

        $this->emailListService->update($list, $validated);

        return redirect()
            ->route('customer.lists.settings', $list)
            ->with('success', 'Settings updated successfully.');
    }
}

