<?php

namespace App\Console\Commands;

use App\Models\ReplyServer;
use App\Services\ReplyProcessorService;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class ProcessReplies extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'email:process-replies';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Process campaign reply emails from the configured reply tracking inbox';

    /**
     * Execute the console command.
     */
    public function handle(ReplyProcessorService $replyProcessor): int
    {
        $this->info('Starting reply processing...');

        try {
            $processed = 0;

            $imap = (array) config('mailpurse.reply_tracking.imap', []);
            $hostname = trim((string) ($imap['hostname'] ?? ''));
            $username = trim((string) ($imap['username'] ?? ''));
            $password = trim((string) ($imap['password'] ?? ''));

            if ($hostname !== '' && $username !== '' && $password !== '') {
                $processed += $replyProcessor->processReplies();
            }

            $servers = ReplyServer::query()
                ->where('active', true)
                ->orderBy('id')
                ->get();

            foreach ($servers as $server) {
                $processed += $replyProcessor->processReplies($server);
            }

            $this->info("Processed {$processed} repl(ies).");
            return Command::SUCCESS;
        } catch (\Exception $e) {
            $this->error('Error processing replies: ' . $e->getMessage());
            Log::error('Error processing replies: ' . $e->getMessage());
            return Command::FAILURE;
        }
    }
}
